*Title: How to Turn Off eAccelerator or XCache?
*Slug: disable-eaccelerator-or-xcache

================================================================

activeCollab does not work well if your server has eAccelerator or XCache configured. Our installation tool will warn you about this and it will not let you proceed, unless you turn  these tools off:

- To turn off **eAccelerator**, make the following changes in your PHP configuration:

<{code}>eaccelerator.enable 0
eaccelerator.optimizer 0<{/code}>

- Disabling the XCache process is similar. To turn off XCache, make the following changes to your PHP configuration:

<{code}>xcache.cacher Off
xcache.size 0
xcache.stat Off<{/code}>

The exact place where these changes need to be made depends on your server configuration. In some cases, where you have access to global PHP settings, you can update the main PHP configuration file (it is called php.ini in most cases). Alternatively, when your host allows changes per folder (via separate php.ini or .htaccess files), make sure that these changes are applied to the <{path}>/public<{/path}> folder of your activeCollab, since all requests are routed through that folder.

For example, if your host lets you override the PHP settings with .htaccess files, you would need to create the .htaccess file in the /public folder of your activeCollab, and put the following content in it:

<{code}>php_flag eaccelerator.enable 0
php_flag eaccelerator.optimizer 0<{/code}>

Please consult your hosting provider for specific information abut the file location.

<{note title="Use APC for Opcode Caching"}>We recommend that you **use APC for opcode and memory caching**. When enabled, your PHP will cache the processed PHP files and will not waste time on file processing on each request (which results in significant performance gain). Also, activeCollab will automatically start using it as the primary caching mechanism, instead of a file based cache, which will also speed things up.

APC is highly recommended if you want good system performance.<{/note}>